// tests/feedback/policy.spec.ts
import { describe, it, expect } from 'vitest';
import { chooseAction, DefaultPolicy } from '../../lib/feedback/policy';
import type { Evaluation } from '../../lib/feedback/types';

describe('Policy Decision Tests', () => {
  it('should trigger rollback on critical error', () => {
    const evaln: Evaluation = {
      score: 90,
      severity: 'CRITICAL',
      confidence: 0.9,
      reasons: ['ERROR=90'],
      bucket: 'DEGRADED',
    };
    const act = chooseAction(evaln, DefaultPolicy);
    expect(act?.kind).toBe('ROLLBACK');
  });

  it('should enable cache on critical latency', () => {
    const evaln: Evaluation = {
      score: 85,
      severity: 'CRITICAL',
      confidence: 0.8,
      reasons: ['LATENCY=80'],
      bucket: 'DEGRADED',
    };
    const act = chooseAction(evaln, DefaultPolicy);
    expect(act?.kind).toBe('ENABLE_CACHE');
  });

  it('should reduce rate on warning', () => {
    const evaln: Evaluation = {
      score: 50,
      severity: 'WARNING',
      confidence: 0.6,
      reasons: ['LOAD=60'],
      bucket: 'VOLATILE',
    };
    const act = chooseAction(evaln, DefaultPolicy);
    expect(act?.kind).toBe('ADJUST_RATE');
  });

  it('should raise limit on confident normal state', () => {
    const evaln: Evaluation = {
      score: 20,
      severity: 'NORMAL',
      confidence: 0.8,
      reasons: [],
      bucket: 'STABLE',
    };
    const act = chooseAction(evaln, DefaultPolicy);
    expect(act?.kind).toBe('RAISE_LIMIT');
  });
});
