// tests/feedback/metrics.spec.ts
import { describe, it, expect } from 'vitest';
import { updateMetrics, getMetrics } from '../../lib/feedback/metrics';

describe('Metrics Tracking Tests', () => {
  it('should update metrics after successful result', () => {
    updateMetrics(true, 100);
    const m = getMetrics();
    expect(m.totalCycles).toBeGreaterThan(0);
    expect(m.avgLatency).toBeGreaterThan(0);
  });

  it('should calculate success rate properly', () => {
    updateMetrics(false, 50);
    const m = getMetrics();
    expect(m.successRate).toBeLessThanOrEqual(1);
  });
});
