const TELEMETRY_ENABLED =
  (typeof process !== 'undefined' && process.env.TEST_TELEMETRY === 'true') ||
  (typeof window !== 'undefined' && (window as any).__TEST_TELEMETRY__ === true);

export const telemetry = {
  log: (...args: any[]) => {
    if (TELEMETRY_ENABLED) {
      // eslint-disable-next-line no-console
      console.log('[Telemetry]', ...args);
    }
  },
  time: (label: string) => {
    if (!TELEMETRY_ENABLED) return { end: () => {} };
    const start = performance.now();
    return {
      end: () => {
        const ms = Math.round(performance.now() - start);
        // eslint-disable-next-line no-console
        console.log(`[Telemetry] ${label} = ${ms}ms`);
      },
    };
  },
};
