// lib/feedback/memory.ts
import type { FeedbackEvent } from './types';

const timeline: FeedbackEvent[] = [];

export async function recordFeedback(event: FeedbackEvent) {
  timeline.push(event);
}

export function getTimeline() {
  return timeline;
}

export function getLastActions(kind: string) {
  return timeline.filter((t) => t.chosenAction?.kind === kind);
}

export function clearTimeline() {
  timeline.length = 0;
}
