// lib/feedback/cooldown.ts

const cooldownMap: Record<string, number> = {};
const backoff: Record<string, number> = {};

export function canRun(kind: string, now: number, cooldownMs = 60000): boolean {
  const last = cooldownMap[kind] || 0;
  return now - last > (backoff[kind] || cooldownMs);
}

export function mark(kind: string, now: number, success: boolean) {
  cooldownMap[kind] = now;
  if (!success) {
    backoff[kind] = (backoff[kind] || 60000) * 2; // Exponential backoff
  } else {
    backoff[kind] = 60000;
  }
}
