import React from 'react';
import { render, RenderOptions } from '@testing-library/react';

type WrapperProps = { children: React.ReactNode };

const AllProviders = ({ children }: WrapperProps) => {
  // تقدر تضيف ThemeProvider/ReducedMotionProvider لو محتاج
  return <>{children}</>;
};

export function customRender(ui: React.ReactElement, options?: Omit<RenderOptions, 'wrapper'>) {
  return render(ui, { wrapper: AllProviders, ...options });
}

export * from '@testing-library/react';
