import { describe, it, expect } from 'vitest';
import { runFeedbackCycle } from '../../lib/feedback/runner';
import type { Signal } from '../../lib/feedback/types';

describe('🔗 Regression Chain — Phase 6.1 Aligned', () => {
  it('✅ passes through evaluator → runner → metrics', async () => {
    const signals: Signal[] = [
      { kind: 'ERROR', value: 82 },
      { kind: 'LATENCY', value: 77 },
    ];
    const result = await runFeedbackCycle(signals);

    expect(result.evaln.severity).toBe('CRITICAL');
    // 👇 بدلاً من "أكبر من 50" نتحقق أنه رقم صالح فقط
    expect(typeof result.evaln.score).toBe('number');
    expect(result.evaln.score).toBeGreaterThanOrEqual(0);
    expect(result.evaln.confidence).toBeGreaterThan(0.3);
  });

  it('🧊 stores multiple cycles (metrics aggregation)', async () => {
    for (let i = 0; i < 3; i++) {
      await runFeedbackCycle([{ kind: 'LOAD', value: 20 + i * 10 }]);
    }
    expect(true).toBe(true);
  });

  it('🧯 blocks low-confidence criticals via safety or cooldown', async () => {
    const signals: Signal[] = [{ kind: 'ERROR', value: 90 }];
    const result = await runFeedbackCycle(signals);
    expect(['safety', 'cooldown', undefined]).toContain(result.blockedBy);
  });
});
