"use client"

import type React from "react"

import { personalInfo } from "@/data/apps" // Updated import path
import styles from "@/components/windows/WindowContent.module.css"
import { Mail, Phone, Linkedin, Github } from "lucide-react"

export default function ContactContent() {
  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    alert("Thank you for your message! This is a demo form.")
    // In a real application, you would send this data to a backend API.
  }

  return (
    <div className={styles.windowContent}>
      <section className={styles.contentSection}>
        <h2>Get In Touch</h2>
        <form onSubmit={handleSubmit} className={styles.contactForm}>
          <div className={styles.formGroup}>
            <label htmlFor="name">Name</label>
            <input type="text" id="name" name="name" required />
          </div>
          <div className={styles.formGroup}>
            <label htmlFor="email">Email</label>
            <input type="email" id="email" name="email" required />
          </div>
          <div className={styles.formGroup}>
            <label htmlFor="subject">Subject</label>
            <input type="text" id="subject" name="subject" required />
          </div>
          <div className={styles.formGroup}>
            <label htmlFor="message">Message</label>
            <textarea id="message" name="message" required />
          </div>
          <button type="submit" className={styles.submitButton}>
            Send Message
          </button>
        </form>
      </section>

      <section className={styles.contentSection}>
        <h2>Other Ways to Connect</h2>
        <div className={styles.contactMethods}>
          <div className={styles.methodCard}>
            <Mail size={40} />
            <p>Email Me</p>
            <a href={`mailto:${personalInfo.email}`}>{personalInfo.email}</a>
          </div>
          <div className={styles.methodCard}>
            <Phone size={40} />
            <p>Call Me</p>
            <a href={`tel:${personalInfo.phone}`}>{personalInfo.phone}</a>
          </div>
          <div className={styles.methodCard}>
            <Linkedin size={40} />
            <p>Connect on LinkedIn</p>
            <a href={personalInfo.linkedin} target="_blank" rel="noopener noreferrer">
              Mohamed Gamal
            </a>
          </div>
          <div className={styles.methodCard}>
            <Github size={40} />
            <p>Follow on GitHub</p>
            <a href={personalInfo.github} target="_blank" rel="noopener noreferrer">
              mohamed-gamal
            </a>
          </div>
        </div>
      </section>
    </div>
  )
}
