// components/__tests__/Window.test.tsx
import { render, screen } from "@testing-library/react";
import Window from "../Window";

describe("Window Component", () => {
  it("renders window title and controls", () => {
    render(
      <Window
        app={{ id: "about", name: "About Me", icon: "🧠", type: "folder" }}
        onClose={() => {}}
        onMinimize={() => {}}
        onFocus={() => {}}
        isActive={true}
        zIndex={100}
        initialPosition={{ x: 0, y: 0 }}
        initialSize={{ width: 800, height: 600 }}
        isMaximized={false}
        setWindowState={() => {}}
      />
    );

    expect(screen.getByText("About Me")).toBeInTheDocument();
  });
});
