/** @type {import('next').NextConfig} */
const nextConfig = {
  reactStrictMode: true,

  // امنع كتم أخطاء TS/ESLint — ده مهم جداً عشان ميبقاش في كراش في البرودكشن
  typescript: { ignoreBuildErrors: false },
  eslint: { ignoreDuringBuilds: false },

  async headers() {
    // افصل كل هيدر في object مستقل — مفيش duplicate keys
    const securityHeaders = [
      {
        key: 'Content-Security-Policy',
        // راجع القيم حسب احتياجك. دي سياسة آمنة كبداية للـ iframe وغيره.
        value: [
          "default-src 'self'",
          "script-src 'self' 'unsafe-inline' 'unsafe-eval'",
          "style-src 'self' 'unsafe-inline'",
          "img-src 'self' data: blob:",
          "font-src 'self' data:",
          "connect-src 'self'",
          'frame-src https: http:',
          "object-src 'none'",
          "base-uri 'self'",
          "form-action 'self'",
          "frame-ancestors 'self'",
          'upgrade-insecure-requests',
        ].join('; '),
      },
      { key: 'X-Content-Type-Options', value: 'nosniff' },
      { key: 'Referrer-Policy', value: 'strict-origin-when-cross-origin' },
      { key: 'Permissions-Policy', value: 'geolocation=(), microphone=(), camera=()' },
    ];

    return [
      {
        source: '/(.*)',
        headers: securityHeaders,
      },
    ];
  },
};

export default nextConfig;
