import { usePolicyContext } from '../context/PolicyContext';

export function useResponsivePolicy() {
  const { policy, device, setOverrides, clearOverrides } = usePolicyContext();
  return {
    policy,
    device,
    isMobile: device === 'mobile',
    isDesktop: device === 'desktop',
    compact: policy.ui.density === 'compact',
    setOverrides,
    clearOverrides,
  };
}
