"use client";

import * as React from "react";

/**
 * Lightweight, type-safe Recharts tooltip wrapper.
 * We deliberately keep props as `any` to avoid generic type clashes
 * and only use the fields we actually need at runtime.
 */
export const CustomTooltip: React.FC<any> = (props: any) => {
  const active = props?.active;
  const payload = props?.payload as any[] | undefined;
  const label = props?.label;

  // No tooltip if nothing is active
  if (!active || !payload || payload.length === 0) {
    return null;
  }

  const first = payload[0] ?? {};
  const name = first.name ?? first.dataKey ?? "value";
  const value = first.value;

  return (
    <div className="rounded-md border border-border/50 bg-background px-3 py-2 text-xs shadow-xl">
      {label && (
        <div className="mb-1 font-medium">
          {typeof label === "number" ? label.toLocaleString() : label}
        </div>
      )}

      <div className="flex items-center justify-between gap-2">
        <span className="text-muted-foreground">
          {typeof name === "string" ? name : "value"}
        </span>

        {value != null && (
          <span className="font-mono font-semibold tabular-nums">
            {Number(value).toLocaleString()}
          </span>
        )}
      </div>
    </div>
  );
};
