/**
 * @file HUDGlitch.tsx
 * Subtle glitch text for headers and badges (brand-friendly, not overdone)
 */

import React from "react";

type Props = {
  children: React.ReactNode;
  accent?: "orange" | "teal";
  className?: string;
};

export const HUDGlitch: React.FC<Props> = ({ children, accent = "orange", className }) => {
  const color = accent === "orange" ? "#f47b46" : "#0c7a7a";
  return (
    <span
      className={`hud-glitch ${className || ""}`}
      style={{ color, textShadow: `0 0 6px ${color}55` }}
      data-glitch={typeof children === "string" ? children : ""}
    >
      {children}
    </span>
  );
};
