import React, { useEffect } from 'react';
import { useResponsivePolicy } from './hooks/useResponsivePolicy';
import { logPolicyApplied } from '@/lib/telemetry/policy.telemetry';

export const IntegrationBridge: React.FC = () => {
  const { policy } = useResponsivePolicy();

  useEffect(() => {
    logPolicyApplied(policy);
  }, [policy]);

  return null;
};
