# System Architecture Master Prompt — Portfolio OS

> **Document Type:** Enterprise Architecture Master Prompt (AI-Ready)
> **Project Name:** Interactive Portfolio OS
> **Repository Path (Local):** `/home/gemmey1020/Documents/JEMY_WORK/tech/me/me/me/me/port` > **Author:** Mohamed Gamal (Jemy)
> **Maintainer:** Mohamed Gamal (Jemy)
> **Version:** v1.0.0
> **Last Updated (UTC):** 2025-10-10T08:40:30Z
> **Intended Consumers:** Gemini CLI, GitHub Copilot, ChatGPT, Claude
> **Primary Output of This Prompt:** `PORTFOLIO_FULL_ARCHITECTURE_REPORT.md` (living reference for all AI tools)

---

## 0) Purpose & Usage

This document is the _sovereign_ prompt for **Gemini CLI** (and any AI code assistant) to produce a **complete, verifiable, and evergreen** architecture report for the **Portfolio OS** repository.
It defines **scope**, **depth**, **format**, **commands**, and **update policy**. Every future refactor **must** be reflected here and in the generated report.

**Run Context:** Open a terminal **inside the repository path** shown above and start Gemini CLI with this prompt.
**Run goal:** Generate a single Markdown artifact with cross-referenced sections, code excerpts, and actionable guidance for engineers.

---

## 1) Analysis Scope (READ CAREFULLY)

Perform an exhaustive **static and semantic analysis** of the entire codebase (Next.js 14, React 18, TS, Tailwind, shadcn/ui, Framer Motion). Include **every relevant technical fact**.

### Include at minimum:

1. **Directory Structure** (tree + purpose for each folder and major file).
2. **Entrypoints & App Shell** (`app/page.tsx`, `app/layout.tsx`, `_app.tsx` if present).
3. **Hooks** — definitions, dependencies, lifecycles, and interactions (e.g., `useWindowManager`, `use-mobile`, theme hooks).
4. **Components** — props, internal state, children, side effects, conditional rendering, and relationships.
5. **Data & Content Sources** — `data/apps.tsx` (desktopApps/allApps, personalInfo, projects, techStack, philosophy, qualifications).
6. **Event Flow** — click/double-click, drag/resize, focus, minimize/maximize, Activities Overview toggling.
7. **State Persistence** — localStorage serialization layout, restore lifecycle, deep-link handling (`?app=<id>`).
8. **Lazy Loading & Suspense** — all dynamic imports, fallback policies, boundary placement.
9. **Styling Layers** — Tailwind, CSS Modules, shadcn/ui; scoping, theme tokens, and custom scrollbars.
10. **Animation** — Framer Motion usage, variants, transitions, reduced-motion handling.
11. **Mobile Handling** — responsive behavior, pointer events, safe-area, SSR-safety (`typeof window`).
12. **Performance** — render frequency, memoization opportunities, effect dependencies, z-index calculations, TopBar clock throttling.
13. **Security/Headers** — iframe sandbox/allow, CSP notes, `next.config.*` headers if present.
14. **SEO/PWA** — metadata in `layout.tsx`, `manifest.json`, icons, OG tags, canonical URLs.
15. **Error Boundaries & Edge Cases** — where handled or missing.
16. **Dependencies Map** — third-party libraries and their roles.
17. **Testing & CI** — presence of Vitest/RTL/Playwright, GitHub Actions, scripts.

> If something **does not exist**, explicitly say “Not Present” and recommend how to add it.

---

## 2) Output Requirements (STRICT)

Produce **one** Markdown file named: **`PORTFOLIO_FULL_ARCHITECTURE_REPORT.md`** in the repository root.
Tone: **Enterprise documentation** (precise, declarative, auditable) + **Developer hints** (snippets, commands).
Target length: **very detailed** (use as many sections and subsections as needed). Avoid fluff.

### Required Sections

1. **Executive Overview** — stack, philosophy, system boundaries.
2. **File Structure Map** — `tree -L 4` style + purpose per directory.
3. **Data & State Management** — global vs local state, hook APIs, persistence diagram.
4. **Component Graph** — components, props, children, event surfaces, lazy modules.
5. **Logic Flow Diagrams** (textual) — _Window Lifecycle_, _Activities Overview_, _Deep-link boot_.
6. **Performance Audit** — re-render hotspots, effect dependency risks, IO costs, bundling advice.
7. **Security & SSR** — window checks, sandboxing, headers.
8. **SEO / PWA** — current status + recommendations.
9. **Testing & CI** — gaps and setup proposal.
10. **Refactor Recommendations** — grouped by **Critical / High / Medium / Low** priority with rationale and code snippets.
11. **AI Integration Metadata** — how Copilot/Gemini/ChatGPT should consume this report as grounding.

> Use **inline code excerpts** with file paths and context. Add **cross-references** (e.g., “see §3.2”).

---

## 3) Commands Gemini Should Execute

Run these commands **within the repository** to collect facts (adapt paths if needed):

```bash
# Confirm structure (adjust -L if needed)
tree -a -I 'node_modules|.git|.next|dist|build' -L 4

# Map components & hooks
grep -RIn "export default function" -- * | sort
grep -RIn "useState\(" -- * | sort
grep -RIn "useEffect\(" -- * | sort
grep -RIn "useCallback\(" -- * | sort
grep -RIn "lazy\(" -- * | sort

# Data & routes
grep -RIn "data/apps" -- * | sort
grep -RIn "app/" -- * | sort

# Styling & UI
grep -RIn "className=" -- * | wc -l
grep -RIn "Window.module.css|WindowContent.module.css|Desktop.module.css" -- * | sort

# Persistence & deep-link
grep -RIn "localStorage|\?app=" -- * | sort

# Dependencies
cat package.json
```

Use command outputs to **ground** your claims. Quote **brief** relevant excerpts when needed.

---

## 4) Report Construction Rules

- **Do not invent** code that doesn’t exist; if a concept is missing, mark it and propose an implementation.
- **Name concrete symbols** (variables, functions, files) whenever possible.
- Provide **before/after** examples for critical refactors (e.g., `useWindowManager` save/persist loop fix; z-index calculation).
- For any **hook**: list input parameters, return API, side-effects, and consumers.
- For **Window** and drag/resize logic: describe event handlers, constraints, and SSR safety.
- Note **mobile-first** behaviors (tap vs double-click) if implemented.
- Highlight **accessibility** (focus rings, keyboard shortcuts) and **reduced-motion** considerations.

---

## 5) Acceptance Criteria (Definition of Done)

- A file named **`PORTFOLIO_FULL_ARCHITECTURE_REPORT.md`** exists in the repo root.
- It contains **all required sections** above.
- It includes **explicit references** to files and symbols inside this repository.
- It provides **actionable** refactor steps with **code snippets**.
- It ends with the exact line:
  `✅ Full Deep Analysis Complete — Report saved as PORTFOLIO_FULL_ARCHITECTURE_REPORT.md`

---

## 6) Update Policy (Living Document)

- **Any code change** impacting architecture/state/data/UI must update:
  1. This master prompt (version bump, date), and
  2. Re-run Gemini to regenerate the report.
- Maintain a **CHANGELOG** block at the end with `YYYY-MM-DD` entries summarizing what changed.

**Versioning Guideline:**

- Patch: wording/typos only (`v1.0.x`)
- Minor: new sections or prompt scope tweaks (`v1.x.0`)
- Major: structural changes in analysis model (`vX.0.0`)

---

## 7) AI Consumption Metadata (for Copilot/Gemini/ChatGPT)

- Treat the generated report as **canonical grounding** for refactors and code generation.
- When proposing code changes, **cite** specific sections (§) and file paths.
- Prefer **data-driven** patterns (e.g., `componentKey` → lazy-loaded content in `Window`).
- Respect **SSR safety**, **accessibility**, and **performance** guidelines from the report.
- Cross-check **effect dependencies** and **memoization** to avoid re-render loops.

---

## 8) Kickoff Instructions (How to Use This File)

1. Open terminal at:
   ```bash
   cd "/home/gemmey1020/Documents/JEMY_WORK/tech/me/me/me/me/port"
   ```
2. Launch Gemini CLI pointing to this prompt:
   ```bash
   gemini --run "./gemini_prompts/PORTFOLIO_OS_SYSTEM_ARCHITECTURE_MASTER_PROMPT.md"
   ```
3. Wait for the analysis to complete and verify the artifact:
   `PORTFOLIO_FULL_ARCHITECTURE_REPORT.md` at repository root.
4. Commit both files (prompt + report) with a message like:
   ```bash
   git add gemini_prompts/PORTFOLIO_OS_SYSTEM_ARCHITECTURE_MASTER_PROMPT.md PORTFOLIO_FULL_ARCHITECTURE_REPORT.md
   git commit -m "docs(ai): add master prompt and generated full architecture report"
   ```

---

## 9) CHANGELOG (for this Prompt)

- **{today} v1.0.0** — Initial enterprise-grade master prompt created; added scope, commands, acceptance criteria, and AI consumption metadata.

> Replace `{today}` with the current date on first commit.

---

**End of Master Prompt.**
