"use client"
import React from "react" // Import React
import styles from "./Experience.module.css"

const Experience: React.FC = () => { // Add React.FC type
  return (
    <div className={styles.experienceContainer}>
      <div className={styles.resumeHeader}>
        <h1>Mohamed Gamal</h1>
        <div className={styles.subtitle}>Team Lead | Full Stack Engineer (Laravel + Vue.js)</div>
        <div className={styles.contactInfo}>
          <p>New Cairo, Egypt</p>
          <p>Email: mohamed49.fcis@gmail.com</p>
          <p>Phone: (+20) 1157-828-998</p>
          <p>
            <a href="https://linkedin.com/in/mohamed-gamal" target="_blank" rel="noopener noreferrer">
              LinkedIn Profile
            </a>
          </p>
          <p>
            <a href="https://github.com/mohamed-gamal" target="_blank" rel="noopener noreferrer">
              GitHub Profile
            </a>
          </p>
          <p>
            <a href="https://mohamed-gamal-portfolio.com" target="_blank" rel="noopener noreferrer">
              Portfolio Website
            </a>
          </p>
        </div>
      </div>

      <section className={styles.resumeSection}>
        <h2>Professional Summary</h2>
        <p>
          Full Stack Engineer with 7+ years building and leading scalable systems in CRM, education, and logistics
          domains. Expert in Laravel (from 4.3 to 12), Vue.js, and API-driven architecture. Known for balancing clean
          code, strategic planning, and people-focused development. Currently leading cross-functional teams to deliver
          business-critical modules and automation solutions.
        </p>
      </section>

      <section className={styles.resumeSection}>
        <h2>Professional Experience</h2>

        <div className={styles.experienceItem}>
          <div className={styles.jobHeader}>
            <h3>Media Factory World | Team Lead – Full Stack Developer</h3>
            <span className={styles.date}>Jan 2024 – Present</span>
          </div>
          <p>Cairo, Egypt</p>
          <ul>
            <li>
              Led the development of a unified enterprise system (orders, vacation, messaging, internal email, and
              vehicle tracking)
            </li>
            <li>Directed 3 developers across backend and frontend, ensured code quality and architecture alignment</li>
            <li>Designed and implemented queue-based notification workflows across roles (member, team leader, HR)</li>
            <li>Integrated FullCalendar.js, multilingual UI, and optimized performance for live data interactions</li>
          </ul>
        </div>

        <div className={styles.experienceItem}>
          <div className={styles.jobHeader}>
            <h3>Partner Analytics | Senior Web Developer</h3>
            <span className={styles.date}>Jul 2023 – Nov 2023</span>
          </div>
          <p>Remote / Cairo</p>
          <ul>
            <li>Built CRM systems (Partner-Constant & Rindex) for real estate workflows and client-side portals</li>
            <li>Created modular dashboards for admins, sales, and support agents</li>
            <li>Handled API integrations, authentication layers, and client-side data flow</li>
          </ul>
        </div>

        <div className={styles.experienceItem}>
          <div className={styles.jobHeader}>
            <h3>MO4 Networks | Senior Web Developer</h3>
            <span className={styles.date}>Mar 2021 – Dec 2022</span>
          </div>
          <p>Cairo, Egypt</p>
          <ul>
            <li>Contributed 45% to Botit app backend, including MongoDB-based data sync with mobile clients</li>
            <li>Developed reusable logic for restaurant, menu, and order workflows</li>
            <li>Handled user auth, cart management, and dynamic delivery logic for high-traffic use</li>
          </ul>
        </div>
      </section>

      <section className={styles.resumeSection}>
        <h2>Highlighted Projects</h2>

        <div className={styles.projectItem}>
          <h3>Easy Cook - Lead Backend Engineer</h3>
          <p className={styles.projectStack}>Laravel, FullCalendar.js, Notifications System</p>
          <p>
            Architected and implemented a subscription-based nutrition platform with role-specific dashboards (Admin,
            Nutritionist, User). Developed logic to track and display meals, macros, and progress using FullCalendar.
            Integrated real-time feedback and payment flow.
          </p>
          <p className={styles.projectHighlight}>💡 Processed over 1,000 assessments/month</p>
        </div>

        <div className={styles.projectItem}>
          <h3>Yousry Group Unified Platform - Team Lead</h3>
          <p className={styles.projectStack}>Laravel, Vue.js, Modular Monolith Architecture</p>
          <p>
            Led the engineering of a multi-module internal system (orders, vacation, notifications, chat, emails,
            transport tracking). Directed a team of 3+ developers, reviewed PRs, and implemented a queue-based
            notification engine with role-based workflows.
          </p>
        </div>

        <div className={styles.projectItem}>
          <h3>Education Matching System - System Designer</h3>
          <p className={styles.projectStack}>Laravel, Matching Engine, Scheduling Logic</p>
          <p>
            Designed and built a smart engine that matches student requests (subject, gender preference, grade level)
            with nearest available teachers. The system auto-generates a proposed lesson schedule and syncs with the
            calendar module.
          </p>
        </div>

        <div className={styles.projectItem}>
          <h3>OrderFei - Shopify Developer</h3>
          <p className={styles.projectStack}>Shopify, WhatsApp Checkout, MyFatoorah API</p>
          <p>
            Developed a bilingual beauty & medical store using Shopify. Customized the theme, optimized mobile checkout
            flow, and built a WhatsApp order redirection system to bypass online payment complexity while integrating
            local gateways (MyFatoorah).
          </p>
        </div>

        <div className={styles.projectItem}>
          <h3>
            Botit Application - Senior Backend Developer |{" "}
            <a
              href="https://www.botitapp.com/"
              target="_blank"
              rel="noopener noreferrer"
              className={styles.projectLink}
            >
              Visit Website
            </a>
          </h3>
          <p className={styles.projectStack}>Laravel, MongoDB, Mobile API Sync</p>
          <p>
            Contributed 45% to backend development of a smart food delivery and automation platform. Built scalable data
            models, user segmentation, and integrated with mobile APIs for real-time menu, location, and cart sync.
            Worked directly with lead product managers for fast iterations.
          </p>
        </div>
      </section>

      <section className={styles.resumeSection}>
        <h2>Technical Skills</h2>
        <ul className={styles.skillsList}>
          <li>
            <strong>Backend:</strong> Laravel (4.3–12), PHP, MySQL, MongoDB, RESTful APIs
          </li>
          <li>
            <strong>Architecture:</strong> SOLID, Clean Code, Queues, Notifications, Scheduling
          </li>
          <li>
            <strong>Frontend:</strong> Vue.js, TailwindCSS, Blade, FullCalendar.js, Bootstrap
          </li>
          <li>
            <strong>DevOps:</strong> Git, Bitbucket, WHM, Deployment, Git Hooks
          </li>
          <li>
            <strong>Tools:</strong> Paymob, MyFatoorah, WHM, cPanel, Trello API
          </li>
          <li>
            <strong>Soft Skills:</strong> Agile, Leadership, Documentation, Team Reviews
          </li>
        </ul>
      </section>

      <section className={styles.resumeSection}>
        <h2>Education</h2>
        <div className={styles.educationItem}>
          <h3>B.Sc. in Computer and Information Science</h3>
          <p>Ain Shams University – Cairo, Egypt | 2015–2021</p>
        </div>
      </section>

      <section className={styles.resumeSection}>
        <h2>Leadership & Philosophy</h2>
        <ul>
          <li>Advocate for logic-driven development over improvisation</li>
          <li>Committed to clean code, documentation, and SOLID architecture</li>
          <li>Believer in tech solutions aligned with real business needs</li>
          <li>Leads by example and promotes team ownership and collaboration</li>
        </ul>
      </section>
    </div>
  )
}

export default Experience; // Export as default