"use client"
import React from "react" // Import React
import styles from "./FolderContent.module.css"

const AdditionalInfoFolder: React.FC = () => { // Add React.FC type
  return (
    <div className={styles.folderContainer}>
      <h1 className={styles.folderTitle}>Professional Experience</h1>

      <div className={styles.additionalInfo}>
        <div className={styles.infoSection}>
          <h2>Professional Summary</h2>
          <p className={styles.summary}>
            Full Stack Engineer with 7+ years building and leading scalable systems in CRM, education, and logistics
            domains. Expert in Laravel (from 4.3 to 12), Vue.js, and API-driven architecture. Known for balancing clean
            code, strategic planning, and people-focused development. Currently leading cross-functional teams to
            deliver business-critical modules and automation solutions.
          </p>
        </div>

        <div className={styles.infoSection}>
          <h2>Current Position</h2>
          <div className={styles.leadershipItem}>
            <h3>Media Factory World | Team Lead – Full Stack Developer</h3>
            <p className={styles.date}>Cairo, Egypt | Jan 2024 – Present</p>
            <ul>
              <li>
                Led the development of a unified enterprise system (orders, vacation, messaging, internal email, and
                vehicle tracking)
              </li>
              <li>
                Directed 3 developers across backend and frontend, ensured code quality and architecture alignment
              </li>
              <li>
                Designed and implemented queue-based notification workflows across roles (member, team leader, HR)
              </li>
              <li>Integrated FullCalendar.js, multilingual UI, and optimized performance for live data interactions</li>
            </ul>
          </div>
        </div>

        <div className={styles.infoSection}>
          <h2>Previous Experience</h2>
          <div className={styles.leadershipItem}>
            <h3>Partner Analytics | Senior Web Developer</h3>
            <p className={styles.date}>Remote / Cairo | Jul 2023 – Nov 2023</p>
            <ul>
              <li>Built CRM systems (Partner-Constant & Rindex) for real estate workflows and client-side portals</li>
              <li>Created modular dashboards for admins, sales, and support agents</li>
              <li>Handled API integrations, authentication layers, and client-side data flow</li>
            </ul>
          </div>
          <div className={styles.leadershipItem}>
            <h3>MO4 Networks | Senior Web Developer</h3>
            <p className={styles.date}>Cairo, Egypt | Mar 2021 – Dec 2022</p>
            <ul>
              <li>Contributed 45% to Botit app backend, including MongoDB-based data sync with mobile clients</li>
              <li>Developed reusable logic for restaurant, menu, and order workflows</li>
              <li>Handled user auth, cart management, and dynamic delivery logic for high-traffic use</li>
            </ul>
          </div>
        </div>

        <div className={styles.infoSection}>
          <h2>Education & Certifications</h2>
          <div className={styles.leadershipItem}>
            <h3>B.Sc. in Computer and Information Science</h3>
            <p>Ain Shams University – Cairo, Egypt | 2015–2021</p>
          </div>
          <ul className={styles.achievementsList}>
            <li>Certified Psychological Counselor – British University & Egyptian Ministry of Foreign Affairs</li>
            <li>Completed 30+ professional courses (Laravel, Vue, API design)</li>
            <li>Solved 100+ programming problems (Codeforces, HackerRank)</li>
          </ul>
        </div>

        <div className={styles.infoSection}>
          <h2>Languages</h2>
          <ul className={styles.languageList}>
            <li>Arabic (Native)</li>
            <li>English (Excellent – written and spoken)</li>
          </ul>
        </div>
      </div>
    </div>
  )
}

export default AdditionalInfoFolder; // Export as default