// tests/feedback/evaluator.spec.ts
import { describe, it, expect } from 'vitest';
import { evaluate } from '../../lib/feedback/evaluator';
import type { Signal } from '../../lib/feedback/types';

describe('Evaluator Tests', () => {
  it('should classify as NORMAL with low values', () => {
    const signals: Signal[] = [
      { id: '1', at: Date.now(), kind: 'FOCUS', value: 10 },
      { id: '2', at: Date.now(), kind: 'LOAD', value: 15 },
    ];
    const result = evaluate(signals);
    expect(result.severity).toBe('NORMAL');
  });

  it('should classify as WARNING when moderate load', () => {
    const signals: Signal[] = [
      { id: '3', at: Date.now(), kind: 'CHURN', value: 50 },
      { id: '4', at: Date.now(), kind: 'LATENCY', value: 55 },
    ];
    const result = evaluate(signals);
    expect(result.severity).toBe('WARNING');
  });

  it('should classify as CRITICAL when high error/latency', () => {
    const signals: Signal[] = [
      { id: '5', at: Date.now(), kind: 'ERROR', value: 90 },
      { id: '6', at: Date.now(), kind: 'LATENCY', value: 85 },
    ];
    const result = evaluate(signals);
    expect(result.severity).toBe('CRITICAL');
  });

  it('should increase confidence with more samples', () => {
    const few = evaluate([{ id: '1', at: Date.now(), kind: 'FOCUS', value: 10 }]);
    const many = evaluate(
      Array.from({ length: 10 }).map((_, i) => ({
        id: `${i}`,
        at: Date.now(),
        kind: 'LOAD',
        value: 30,
      }))
    );
    expect(many.confidence).toBeGreaterThan(few.confidence);
  });
});
