import type { Evaluation } from './types';

export const DefaultPolicy = {
  version: '1.0.0',
  cooldownMs: 3000,
  params: { rateStep: 0.1 },
};

/**
 * 🧩 اختيار التصرف المناسب حسب النتيجة
 */
export function chooseAction(evaln: Evaluation, policy = DefaultPolicy) {
  const reasons = evaln.reasons || [];

  // 🟢 NORMAL → RAISE_LIMIT لو الثقة عالية
  if (evaln.severity === 'NORMAL') {
    if (evaln.confidence >= 0.7) {
      return { id: crypto.randomUUID(), kind: 'RAISE_LIMIT' };
    }
    return null;
  }

  // ⚠️ WARNING → خفض السرعة
  if (evaln.severity === 'WARNING') {
    return {
      id: crypto.randomUUID(),
      kind: 'ADJUST_RATE',
      args: { delta: -policy.params.rateStep / 2 },
    };
  }

  // 🚨 CRITICAL → ROLLBACK أولوية للأخطاء ثم CACHE للـ LATENCY
  if (evaln.severity === 'CRITICAL') {
    if (reasons.some((r) => r.includes('ERROR'))) {
      return { id: crypto.randomUUID(), kind: 'ROLLBACK' };
    }
    if (reasons.some((r) => r.includes('LATENCY'))) {
      return { id: crypto.randomUUID(), kind: 'ENABLE_CACHE' };
    }
    return { id: crypto.randomUUID(), kind: 'ROLLBACK' };
  }

  return null;
}
