"use client"

import type React from "react"

import { memo } from "react"
import { motion } from "framer-motion"
import styles from "./DesktopIcon.module.css"

interface DesktopIconProps {
  app: {
    id: string
    name: string
    icon: string
    type: string
  }
  isSelected: boolean
  onClick: (e: React.MouseEvent) => void
  onDoubleClick: () => void
}

const DesktopIcon = memo(function DesktopIcon({ app, isSelected, onClick, onDoubleClick }: DesktopIconProps) {
  return (
    <motion.div
      className={`${styles.desktopIcon} ${isSelected ? styles.selected : ""}`}
      onClick={onClick}
      onDoubleClick={onDoubleClick}
      whileHover={{ scale: 1.05 }}
      whileTap={{ scale: 0.95 }}
      layout
    >
      <div className={styles.iconContainer}>
        <span className={styles.icon}>{app.icon}</span>
      </div>
      <span className={styles.iconName}>{app.name}</span>
    </motion.div>
  )
})

export default DesktopIcon
