import { describe, it, expect } from 'vitest';
import fs from 'node:fs';

describe('Integration Runner — Evolution Report', () => {
  it('should generate Evolution_Report.json with required keys', async () => {
    // نفترض إن الرانر اتشغل قبل التيست (أو اشغّله بعملية منفصلة)
    const path = './storage/Evolution_Report.json';
    expect(fs.existsSync(path)).toBe(true);

    const json = JSON.parse(fs.readFileSync(path, 'utf8'));
    expect(json.metrics).toBeDefined();
    expect(
      ['adaptationRate', 'stabilityIndex', 'metaCognitionLevel', 'nextRecommendedMutation'].every(
        (k) => k in json.metrics
      )
    ).toBe(true);
  });
});
