// tests/feedback/safety.spec.ts
import { describe, it, expect } from 'vitest';
import { guard } from '../../lib/feedback/safety';
import type { Evaluation } from '../../lib/feedback/types';

describe('Safety Guard Tests', () => {
  it('should block extremely degraded state', () => {
    const evaln: Evaluation = {
      score: 95,
      severity: 'CRITICAL',
      confidence: 0.9,
      reasons: [],
      bucket: 'DEGRADED',
    };
    expect(guard(evaln)).toBe(false);
  });

  it('should block very low confidence', () => {
    const evaln: Evaluation = {
      score: 50,
      severity: 'WARNING',
      confidence: 0.1,
      reasons: [],
      bucket: 'VOLATILE',
    };
    expect(guard(evaln)).toBe(false);
  });

  it('should allow safe state', () => {
    const evaln: Evaluation = {
      score: 30,
      severity: 'NORMAL',
      confidence: 0.8,
      reasons: [],
      bucket: 'STABLE',
    };
    expect(guard(evaln)).toBe(true);
  });
});
