// lib/feedback/safety.ts
import { Evaluation } from './types';

export function guard(evaluation: Evaluation): boolean {
  // منع تنفيذ أي فعل أثناء حالة DEGRADED شديدة
  if (evaluation.bucket === 'DEGRADED' && evaluation.score > 90) {
    console.warn('[SAFETY] Too degraded — blocking actions');
    return false;
  }

  // منع التنفيذ لو الثقة منخفضة جدًا
  if (evaluation.confidence < 0.2) {
    console.warn('[SAFETY] Low confidence — skipping');
    return false;
  }

  return true;
}
