// أنواع معرفّة لمرة واحدة ويُعاد استخدامها

export type AppId =
  | 'about'
  | 'projects'
  | 'skills'
  | 'contact'
  | 'resume'
  | 'github'
  | 'linkedin'
  | 'chrome'
  | (string & {}); // للسماح بتوسعات لاحقة

export interface AppMeta {
  id: AppId;
  name: string;
  icon: string; // emoji أو اسم أيقونة
  type: 'internal' | 'external' | 'browser';
  url?: string; // للروابط/المتصفح
  openWindow?: (app: AppMeta) => void; // يُحقن عند الحاجة
  // Optional in-repo component reference for internal apps (kept `any` to avoid coupling types)
  component?: any;
}

export interface WindowState {
  position: { x: number; y: number };
  size: { width: number; height: number };
  isMaximized: boolean;
}
