export type Timestamp = string;

export interface PolicyOutcome {
  policyId: string;
  score: number; // 0..1 normalized
  failureRate: number; // 0..1
  iteration: number;
  timestamp: Timestamp;
}

export interface Snapshot {
  id: string;
  timestamp: Timestamp;
  outcomes: PolicyOutcome[];
  notes?: string;
}

export interface LongTermMetrics {
  stability: number; // variance of scores
  adaptationRate: number; // mean delta across snapshots
  evolutionScore: number; // composite indicator
}

export interface LongTermState {
  snapshots: Snapshot[];
  metrics: LongTermMetrics | null;
}
