import { describe, it, expect } from 'vitest';
import { predictNext } from '@/lib/evolution/predictive-engine';

describe('OS-HISTORICAL-PREDICTIVE-001', () => {
  it('predicts next directive and stability trend', () => {
    const data = [
      { t: 'A', stability: 0.7, adaptationRate: 0.02, directive: 'Hold' },
      { t: 'B', stability: 0.73, adaptationRate: 0.02, directive: 'Adapt' },
      { t: 'C', stability: 0.76, adaptationRate: 0.02, directive: 'Expand' },
    ];
    const pred = predictNext(data)!;
    expect(pred.nextDirective).toBe('Expand');
    expect(pred.predictedStability).toBeGreaterThan(0.76);
  });
});
