// tests/phase7/hud/hud-regression.snap.spec.tsx
import { describe, it, expect, beforeEach } from "vitest";
import { render } from "@testing-library/react";
import { AISummaryPanel } from "@/lib/awareness/collective/components/AISummaryPanel";
import { NeuralVoiceHUD } from "@/lib/awareness/collective/components/NeuralVoiceHUD";
import { ExportCenter } from "@/lib/awareness/collective/components/ExportCenter";

/**
 * HUD Regression Snapshot Suite
 * -----------------------------
 * هدف التيستات دي إننا نثبت baseline لشكل واجهات HUD
 * علشان لو التصميم أو النصوص اتغيرت مستقبلًا، يكتشف التست الاختلاف.
 */

describe("HUD Regression Snapshot Suite", () => {
  beforeEach(() => {
    // snapshot يكون consistent
    vi.useFakeTimers();
    vi.setSystemTime(0);
  });

  it("AISummaryPanel snapshot matches baseline", () => {
    const { container } = render(<AISummaryPanel onClose={() => {}} />);
    expect(container).toMatchSnapshot();
  });

  it("NeuralVoiceHUD snapshot matches baseline", () => {
    const { container } = render(<NeuralVoiceHUD onClose={() => {}} />);
    expect(container).toMatchSnapshot();
  });

  it("ExportCenter snapshot matches baseline", () => {
    const { container } = render(<ExportCenter />);
    expect(container).toMatchSnapshot();
  });
});
