"use client";

/**
 * HUDStyleLayer — Phase 006.9.13
 * Global visual style for all overlays (AISummaryPanel + NeuralVoiceHUD)
 * Adds unified blur, glow, vignette, and depth tone
 */

import React from "react";
import { motion } from "framer-motion";

export const HUDStyleLayer: React.FC<{ children: React.ReactNode }> = ({ children }) => {
  return (
    <motion.div
      className="fixed inset-0 flex items-center justify-center pointer-events-auto"
      style={{
        zIndex: 2147483610,
        backdropFilter: "blur(32px) saturate(180%)",
        background: "linear-gradient(135deg, rgba(0,8,20,0.78) 0%, rgba(0,10,25,0.88) 100%)",
        boxShadow: "inset 0 0 120px rgba(0,255,255,0.06)",
      }}
      initial={{ opacity: 0 }}
      animate={{ opacity: 1 }}
      exit={{ opacity: 0 }}
    >
      {/* subtle neon pulse */}
      <motion.div
        className="absolute inset-0 pointer-events-none"
        animate={{
          background:
            ["radial-gradient(circle at 30% 40%, rgba(14,165,233,0.08) 0%, transparent 70%)",
             "radial-gradient(circle at 70% 60%, rgba(6,182,212,0.1) 0%, transparent 70%)"],
        }}
        transition={{ duration: 6, repeat: Infinity, repeatType: "reverse" }}
      />
      {children}
    </motion.div>
  );
};
