// lib/feedback/types.ts

export type Signal = {
  id: string;
  at: number;
  kind: 'FOCUS' | 'CHURN' | 'ERROR' | 'LATENCY' | 'MEMORY_DRIFT' | 'LOAD';
  value: number;
  meta?: Record<string, any>;
};

export type Evaluation = {
  score: number;
  severity: 'NORMAL' | 'WARNING' | 'CRITICAL';
  confidence: number;
  reasons: string[];
  bucket: 'STABLE' | 'VOLATILE' | 'DEGRADED';
};

export type Policy = {
  id: string;
  name: string;
  version: string;
  // optional cooldown window (ms)
  cooldownMs?: number;
  params: Record<string, any>;
  createdAt: number;
  prevVersion?: string;
};

export type Action = {
  id: string;
  kind: 'ADJUST_RATE' | 'ENABLE_CACHE' | 'DISABLE_FEATURE' | 'RAISE_LIMIT' | 'ROLLBACK';
  args?: Record<string, any>;
};

export type ActionResult = {
  actionId: string;
  ok: boolean;
  latencyMs: number;
  effect?: Record<string, number>;
  error?: string;
};

export type FeedbackEvent = {
  at: number;
  evaluation: Evaluation;
  chosenAction: Action | null;
  result?: ActionResult;
  policyVersion: string;
  blockedBy?: string | null;
};
