/**
 * Phase 6.3 — A/B Simulation Engine
 * إنشاء نسخ تجريبية (mutations) من كل policy وتجربتها افتراضيًا.
 */

import { mutateWeight } from './mutation_utils';
import { selectImproved } from './selection_utils';
import { EvolutionConfig } from '../../config/evolution.config';

/**
 * تجري محاكاة لعدة نسخ من Policy واحدة وتعيد نتائجها.
 */
export function runABSimulation(policy: any, metrics: any) {
  const results = [];
  const { populationSize, mutationRate, selectionThreshold, simulationIterations } =
    EvolutionConfig;

  for (let i = 0; i < populationSize; i++) {
    const mutated = { ...policy };
    mutated.weight = mutateWeight(policy.weight, mutationRate);

    // نحاكي الأداء الافتراضي للنسخة الجديدة
    const simulatedScores = [];
    for (let j = 0; j < simulationIterations; j++) {
      const perf = simulatePerformance(mutated.weight, metrics.evolutionScore);
      simulatedScores.push(perf);
    }

    const avgScore = simulatedScores.reduce((a, b) => a + b, 0) / simulatedScores.length;
    const isBetter = selectImproved(metrics.evolutionScore, avgScore, selectionThreshold);

    results.push({
      policyId: policy.policyId,
      baseWeight: policy.weight,
      newWeight: mutated.weight,
      avgScore,
      accepted: isBetter,
    });
  }

  return results;
}

/**
 * محاكاة أداء النسخة التجريبية بناءً على الوزن والتطور العام.
 */
function simulatePerformance(weight: number, evolutionScore: number): number {
  const randomness = Math.random() * 0.02 - 0.01; // ±1% ضوضاء
  const bias = (weight - 0.5) * 0.1; // الوزن الأعلى يميل للتحسن
  return evolutionScore + bias + randomness;
}
