/**
 * المرحلة الأخيرة — بناء قواعد تطورية واعية
 * من خلال تحليل الاتجاهات المتكررة.
 */

import { ConsciousConfig } from '../../config/conscious.config';
import fs from 'node:fs';

export function refineRules() {
  const path = ConsciousConfig.storagePath;
  if (!fs.existsSync(path)) return [];

  const insights: any[] = JSON.parse(fs.readFileSync(path, 'utf8'));
  const grouped: Record<string, any[]> = {};

  for (const ins of insights) {
    if (!grouped[ins.policyId]) grouped[ins.policyId] = [];
    grouped[ins.policyId].push(ins);
  }

  const refined = Object.entries(grouped).map(([policyId, arr]) => {
    const positives = arr.filter((i) => i.correlation > 0).length;
    const negatives = arr.length - positives;
    const trend = positives >= negatives ? 'reinforce' : 'suppress';

    return {
      policyId,
      recommendation:
        trend === 'reinforce'
          ? 'استمر في زيادة الوزن تدريجيًا'
          : 'خفّض الوزن أو راقب التأثير لاحقًا',
      confidence: (positives / arr.length).toFixed(2),
    };
  });

  return refined;
}
