/**
 * @file MotionWrapper.tsx
 * A simple framer-motion wrapper with tasteful entrance + hover animations
 */

import React from "react";
import { motion } from "framer-motion";

type Props = {
  children: React.ReactNode;
  delay?: number;
  hoverLift?: boolean;
  className?: string;
};

export const MotionWrapper: React.FC<Props> = ({
  children,
  delay = 0,
  hoverLift = true,
  className,
}) => {
  return (
    <motion.div
      className={className}
      initial={{ opacity: 0, y: 14, scale: 0.98 }}
      animate={{ opacity: 1, y: 0, scale: 1 }}
      transition={{ duration: 0.5, ease: "easeOut", delay }}
      whileHover={hoverLift ? { y: -3 } : undefined}
    >
      {children}
    </motion.div>
  );
};
