/**
 * @file ConfidenceHUD.tsx
 * واجهة تعرض الثقة العامة في النظام على هيئة عدّاد نصف دائري
 */

import React, { useEffect, useState } from "react";
import { getPredictiveConfidence } from "@/lib/evolution/predictive-engine";

export const ConfidenceHUD: React.FC = () => {
  const [confidence, setConfidence] = useState(getPredictiveConfidence());

  useEffect(() => {
    const interval = setInterval(() => {
      setConfidence(getPredictiveConfidence());
    }, 2000);
    return () => clearInterval(interval);
  }, []);

  const percent = Math.round(confidence * 100);
  const strokeColor =
    percent > 75 ? "#00ff88" : percent > 50 ? "#f4d03f" : "#ff4d4f";

  return (
    <div className="confidence-hud bg-[#111] rounded-2xl p-5 shadow-lg border border-[#222] flex flex-col items-center">
      <h3 className="text-[#0c7a7a] mb-3 font-semibold text-lg">
        System Confidence
      </h3>
      <svg width="120" height="70" viewBox="0 0 120 70">
        <path
          d="M10 60 A50 50 0 0 1 110 60"
          fill="none"
          stroke="#222"
          strokeWidth="10"
        />
        <path
          d="M10 60 A50 50 0 0 1 110 60"
          fill="none"
          stroke={strokeColor}
          strokeWidth="10"
          strokeDasharray={`${percent * 1.57},157`}
          strokeLinecap="round"
        />
        <text
          x="60"
          y="50"
          textAnchor="middle"
          fontSize="16"
          fill="#f47b46"
          fontWeight="bold"
        >
          {percent}%
        </text>
      </svg>
      <p className="text-gray-400 mt-3 text-sm">
        {percent > 80
          ? "High Predictive Trust"
          : percent > 60
          ? "Stable Operation"
          : "Monitor Adjustments"}
      </p>
    </div>
  );
};
