// src/lib/awareness/collective/analysis/predict-next.ts
import { ChartDataPoint } from '../components/charts/types';

export interface PredictedPoint {
  timestamp: number;
  trendValue: number;
  confidence: number;
  isPrediction: true;
}

export function predictNextTrend(
  logs: ChartDataPoint[],
  windowSize: number = 5
): PredictedPoint | null {
  if (!logs || logs.length < windowSize) return null;

  const slice = logs.slice(-windowSize);

  const avgChange = slice.reduce((s, l) => s + l.changeRate, 0) / slice.length;
  const avgConf = slice.reduce((s, l) => s + l.confidence, 0) / slice.length;
  const last = logs[logs.length - 1];

  let predictedTrend = last.trendValue;

  // 🔺 منطق التنبؤ البسيط
  if (avgConf > 0.6) {
    if (avgChange > 15) predictedTrend = Math.min(3, last.trendValue + 1) as 1 | 2 | 3;
    else if (avgChange < -15) predictedTrend = Math.max(1, last.trendValue - 1) as 1 | 2 | 3;
  }

  return {
    timestamp: last.timestamp + 24 * 60 * 60 * 1000, // بعد يوم
    trendValue: predictedTrend,
    confidence: avgConf,
    isPrediction: true,
  };
}
