// src/lib/awareness/collective/analysis/analysis-utils.ts
export function average(nums: number[]): number {
  return nums.length ? nums.reduce((a, b) => a + b, 0) / nums.length : 0;
}

export function variance(nums: number[]): number {
  const avg = average(nums);
  return average(nums.map((n) => Math.pow(n - avg, 2)));
}

export function stdDev(nums: number[]): number {
  return Math.sqrt(variance(nums));
}
