"use client";

import { techStack } from "@/data/apps";
import styles from "@/components/windows/WindowContent.module.css";
import {
  Code,
  Database,
  Laptop,
  Users,
  Brain,
  Wrench,
  Server,
  GitBranch,
  CreditCard,
  Map,
  Trello,
  MessageSquare,
  Feather,
  BookOpen,
  Lightbulb,
  Smile,
} from "lucide-react";
import type { JSX } from "react";

// 🧠 Debug toggle
const DEBUG =
  (typeof process !== "undefined" &&
    process.env.NODE_ENV !== "production") ||
  (typeof process !== "undefined" &&
    process.env.NEXT_PUBLIC_DEBUG === "true");

const dlog = (...args: any[]) => {
  if (DEBUG) console.log("[SkillsContent]", ...args);
};

// 🔠 Emoji → Icon mapping
const iconMap: { [key: string]: JSX.Element } = {
  "🔧": <Wrench size={18} />,
  "🐘": <Feather size={18} />,
  "🗄️": <Database size={18} />,
  "🍃": <Server size={18} />,
  "🔗": <Code size={18} />,
  "🏗️": <Lightbulb size={18} />,
  "⚛️": <Laptop size={18} />,
  "💚": <Laptop size={18} />,
  "📜": <Code size={18} />,
  "🎨": <Laptop size={18} />,
  "⚔️": <Code size={18} />,
  "🅱️": <Laptop size={18} />,
  "📝": <GitBranch size={18} />,
  "🪣": <GitBranch size={18} />,
  "🪝": <GitBranch size={18} />,
  "🖥️": <Server size={18} />,
  "🚀": <Server size={18} />,
  "💳": <CreditCard size={18} />,
  "💰": <CreditCard size={18} />,
  "🗺️": <Map size={18} />,
  "📋": <Trello size={18} />,
  "📱": <MessageSquare size={18} />,
  "👑": <Users size={18} />,
  "🔄": <Users size={18} />,
  "👥": <Users size={18} />,
  "🎓": <Users size={18} />,
  "📚": <BookOpen size={18} />,
  "🏛️": <Brain size={18} />,
  "🤖": <Brain size={18} />,
  "🧠": <Brain size={18} />,
  "🧘": <Smile size={18} />,
};

export default function SkillsContent() {
  const safeTechStack = techStack && typeof techStack === "object" ? techStack : {};

  const categories = Object.entries(safeTechStack);
  dlog(`🧱 Rendering ${categories.length} skill categories`);

  if (categories.length === 0) {
    dlog("⚠️ No techStack data found.");
    return (
      <div className={styles.windowContent}>
        <section className={styles.contentSection}>
          <h2>Technical Skills & Expertise</h2>
          <p>No technical skills data available at the moment.</p>
        </section>
      </div>
    );
  }

  return (
    <div className={styles.windowContent}>
      <section className={styles.contentSection}>
        <h2>Technical Skills & Expertise</h2>
        <div className={styles.skillsGrid}>
          {categories.map(([category, skills]) => {
            if (!Array.isArray(skills)) return null;

            dlog(`📂 ${category}: ${skills.length} skills`);

            return (
              <div key={category} className={styles.skillCategory}>
                <h3>{category.charAt(0).toUpperCase() + category.slice(1)}</h3>
                <ul className={styles.skillList}>
                  {skills.map((skill, index) => {
                    const safeIcon = iconMap[skill.icon] || <Code size={18} />;
                    const name = skill.name || "Unnamed Skill";
                    const level = skill.level || "N/A";
                    const years = skill.years || "—";

                    return (
                      <li key={index} className={styles.skillItem}>
                        {safeIcon} {name} ({level} - {years})
                      </li>
                    );
                  })}
                </ul>
              </div>
            );
          })}
        </div>
      </section>
    </div>
  );
}
