"use client"

import { memo } from "react"
import { motion } from "framer-motion"
import { Search, Power } from "lucide-react"

import styles from "./TopBar.module.css"

interface TopBarProps {
  toggleActivities: () => void
  activitiesOpen: boolean
  onLogout: () => void
}

const TopBar = memo(function TopBar({ toggleActivities, activitiesOpen, onLogout }: TopBarProps) {
  const currentTime = new Date().toLocaleTimeString([], { hour: "2-digit", minute: "2-digit" })
  const currentDate = new Date().toLocaleDateString([], {
    weekday: "short",
    month: "short",
    day: "numeric",
  })

  return (
    <motion.div
      className={styles.topBar}
      initial={{ y: -60, opacity: 0 }}
      animate={{ y: 0, opacity: 1 }}
      transition={{ duration: 0.3 }}
    >
      <div className={styles.leftSection}>
        <button
          className={`${styles.activitiesButton} ${activitiesOpen ? styles.active : ""}`}
          onClick={toggleActivities}
          type="button"
        >
          <Search size={16} />
          <span>Activities</span>
        </button>
      </div>

      <div className={styles.centerSection}>
        <span className={styles.title}>Mohamed Gamal - Portfolio</span>
      </div>

      <div className={styles.rightSection}>
        <div className={styles.timeDisplay}>
          <span className={styles.time}>{currentTime}</span>
          <span className={styles.date}>{currentDate}</span>
        </div>
       <button
  className={styles.powerButton}
  type="button"
  aria-label="Power"
  title="Power"
>
 <Power aria-hidden="true" />
</button>

      </div>
    </motion.div>
  )
})

export default TopBar
