"use client"

import { motion } from "framer-motion"
import styles from "./PortfolioGrid.module.css"

interface PortfolioGridProps {
  openWindow: (app: any) => void
}

export default function PortfolioGrid({ openWindow }: PortfolioGridProps) {
  const portfolioItems = [
    { id: "project1", name: "Project 1", icon: "🚀" },
    { id: "project2", name: "Project 2", icon: "💻" },
    { id: "project3", name: "Project 3", icon: "🎨" },
    { id: "project4", name: "Project 4", icon: "📱" },
  ]

  return (
    <div className={styles.portfolioGrid}>
      <motion.h2
        className={styles.title}
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ delay: 0.5 }}
      >
        Featured Projects
      </motion.h2>
      <div className={styles.grid}>
        {portfolioItems.map((item, index) => (
          <motion.div
            key={item.id}
            className={styles.portfolioItem}
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ delay: 0.6 + index * 0.1 }}
            whileHover={{ scale: 1.05 }}
            onClick={() => openWindow(item)}
          >
            <span className={styles.itemIcon}>{item.icon}</span>
            <span className={styles.itemName}>{item.name}</span>
          </motion.div>
        ))}
      </div>
    </div>
  )
}
