"use client"
import React, { useState, useRef } from "react" // Import React
import { motion } from "framer-motion"
import { ArrowLeft, ArrowRight, RotateCcw, Star, X, Globe, ExternalLink, Mail } from "lucide-react"
import styles from "./SocialBrowser.module.css"

const MailBrowser: React.FC = () => { // Add React.FC type
  const [isLoading, setIsLoading] = useState(true)
  const browserContentRef = useRef<HTMLDivElement>(null) // Add type to useRef

  // Simulate loading
  setTimeout(() => {
    setIsLoading(false)
  }, 800)

  return (
    <div className={styles.browser} onClick={(e) => e.stopPropagation()}>
      <div className={styles.toolbar}>
        <div className={styles.tabBar}>
          <div className={styles.tab}>
            <div className={styles.favicon}>
              <Mail size={16} color="#0078d7" />
            </div>
            <span className={styles.tabTitle}>Mail - thefstack@gmail.com</span>
            <X size={14} className={styles.closeTab} onClick={(e) => e.stopPropagation()} />
          </div>
        </div>
      </div>

      <div className={styles.addressBar}>
        <div className={styles.navigationButtons}>
          <button className={styles.navButton}>
            <ArrowLeft size={16} />
          </button>
          <button className={styles.navButton}>
            <ArrowRight size={16} />
          </button>
          <button className={styles.navButton}>
            <RotateCcw size={16} />
          </button>
        </div>

        <div className={styles.urlBar}>
          <Globe size={14} className={styles.urlIcon} />
          <span className={styles.urlText}>mailto:thefstack@gmail.com</span>
        </div>

        <div className={styles.browserActions}>
          <button className={styles.actionButton}>
            <Star size={16} />
          </button>
        </div>
      </div>

      <div ref={browserContentRef} className={styles.browserContent}>
        {isLoading ? (
          <div className={styles.loadingIndicator}>
            <motion.div
              className={styles.loadingBar}
              initial={{ width: 0 }}
              animate={{ width: "100%" }}
              transition={{ duration: 1.5 }}
            />
          </div>
        ) : (
          <div className={styles.externalSitePrompt}>
            <div className={styles.externalSiteIcon}>
              <Mail size={68} color="#0078d7" />
            </div>
            <h2 className={styles.externalSiteTitle}>Send Email</h2>
            <p className={styles.externalSiteDescription}>
              Click the button below to open your default email client and send an email to thefstack@gmail.com
            </p>
            <a
              href="mailto:thefstack@gmail.com"
              target="_blank"
              rel="noopener noreferrer"
              className={styles.externalSiteButton}
            >
              <ExternalLink size={16} className={styles.externalLinkIcon} />
              Compose Email
            </a>
          </div>
        )}
      </div>
    </div>
  )
}

export default MailBrowser; // Export as default