export type AwarenessEvent =
  | { type: 'WINDOW_OPENED'; windowId: string }
  | { type: 'WINDOW_FOCUSED'; windowId: string }
  | { type: 'DESKTOP_LOADED' }
  | { type: 'ERROR'; message: string };

const AWARENESS_ENABLED =
  (typeof process !== 'undefined' && process.env.TEST_AWARENESS === 'true') ||
  (typeof window !== 'undefined' && (window as any).__TEST_AWARENESS__ === true);

export function awarenessEmit(ev: AwarenessEvent) {
  if (!AWARENESS_ENABLED) return;
  // eslint-disable-next-line no-console
  console.log('[Awareness]', JSON.stringify(ev));
}
