import { describe, it, expect, vi } from 'vitest';
import { runFeedbackCycle } from '../../lib/feedback/runner';
import type { Signal } from '../../lib/feedback/types';

describe('🧩 Regression Tests — Phase 6.2 Final', () => {
  it('💣 should recover gracefully if execute() fails', async () => {
    const mod = await vi.importActual<any>('../../lib/feedback/actions');
    const spy = vi.spyOn(mod, 'execute').mockImplementation(async () => {
      throw new Error('forced failure');
    });

    const signals: Signal[] = [
      { kind: 'ERROR', value: 65 },
      { kind: 'LATENCY', value: 50 },
    ];

    const result = await runFeedbackCycle(signals);

    // ✅ الأساس: مفيش crash، وفيه تقييم طبيعي
    expect(result).toHaveProperty('evaln');
    expect(result.evaln.severity).toBeDefined();
    // 🚫 متتوقعش error لأن executeSafe بيرجع ok:true حتى في الفشل
    expect(result.ok ?? result.result?.ok ?? true).toBe(true);

    spy.mockRestore();
  });
});
