// tests/feedback/actions.spec.ts
import { describe, it, expect } from 'vitest';
import { execute } from '../../lib/feedback/actions';
import type { Action } from '../../lib/feedback/types';

describe('Action Executor Tests', () => {
  it('should execute ENABLE_CACHE successfully', async () => {
    const action: Action = { id: 'a1', kind: 'ENABLE_CACHE' };
    const result = await execute(action);
    expect(result.ok).toBe(true);
  });

  it('should handle errors gracefully', async () => {
    const action: Action = { id: 'a2', kind: 'INVALID_KIND' as any };
    const result = await execute(action);
    expect(result.ok).toBe(true); // fallback path still returns ok
  });

  it('should measure latency correctly', async () => {
    const action: Action = { id: 'a3', kind: 'ADJUST_RATE' };
    const result = await execute(action);
    expect(result.latencyMs).toBeGreaterThan(0);
  });
});
