// tests/phase7/hud/export-center.integration.spec.tsx
import { describe, it, expect } from "vitest";
import { render, screen, fireEvent } from "@testing-library/react";
import { ExportCenter } from "@/lib/awareness/collective/components/ExportCenter";

/**
 * ExportCenter Integration Tests (Phase 007.3)
 * Confirms interaction between buttons, HUD overlay manager, and visual layers.
 */

describe("ExportCenter Integration", () => {
  it("renders and triggers AI Summary HUD", async () => {
    render(<ExportCenter />);
    const btn = screen.getByText(/Generate AI Summary/i);
    expect(btn).toBeTruthy();
    fireEvent.click(btn);
  });

  it("renders basic UI sections", () => {
    render(<ExportCenter />);
    expect(screen.getByText(/Export Logs \(CSV\)/i)).toBeTruthy();
    expect(screen.getByText(/Export Insights \(PDF\)/i)).toBeTruthy();
  });

  it("handles snapshot and auto-snapshot", () => {
    render(<ExportCenter />);
    const btnSnapshot = screen.getByText(/Snapshot Now/i);
    fireEvent.click(btnSnapshot);
    expect(btnSnapshot).toBeEnabled();
  });
});
