// tests/phase9/hud/ai-summary-panel.spec.tsx
import { describe, it, expect, beforeEach, afterEach, vi } from "vitest";
import { render, screen, act, cleanup } from "@testing-library/react";
import { AISummaryPanel } from "@/lib/awareness/collective/components/AISummaryPanel";

/**
 * AI Summary Panel Tests (Phase 9.3)
 * Verifies dynamic rendering, typing effect, and close behavior.
 */

describe("AISummaryPanel", () => {
  beforeEach(() => {
    vi.useFakeTimers();
  });

  afterEach(() => {
    cleanup();
    vi.useRealTimers();
  });

  it("renders with correct title", () => {
    render(<AISummaryPanel onClose={() => {}} />);
    expect(screen.getByText("Neural Summary Generator")).toBeInTheDocument();
  });

  it("animates typing sequence and completes summary", async () => {
    render(<AISummaryPanel onClose={() => {}} />);
    await act(async () => {
      vi.advanceTimersByTime(4000);
    });
    const indexLabel = screen.getByText(/Stability Index/i);
    expect(indexLabel).toBeInTheDocument();
  });

  it("calls onClose when close button clicked", async () => {
    const mockClose = vi.fn();
    render(<AISummaryPanel onClose={mockClose} />);
    const btn = screen.getByText("Close");
    await act(async () => btn.click());
    expect(mockClose).toHaveBeenCalledOnce();
  });
});
