import { describe, it, expect } from 'vitest';
import {
  getEvolutionLogs,
  logSnapshot,
  clearEvolutionLogs,
} from '../../lib/evolution/history.collector';

const isISO = (s: string) => !Number.isNaN(Date.parse(s));
const in01 = (n: number) => n >= 0 && n <= 1;

describe('Evolution Logs – structure contract', () => {
  it('latest log matches the expected shape', () => {
    clearEvolutionLogs(); // نبدأ بنظافة
    logSnapshot({ notes: 'test:seed' }); // 🧩 تولّد snapshot واحد

    const all = getEvolutionLogs();
    expect(Array.isArray(all)).toBe(true);
    expect(all.length).toBeGreaterThan(0); // ✅ هيعدي المرة دي

    const last = all[all.length - 1];
    expect(last).toEqual(
      expect.objectContaining({
        id: expect.any(String),
        timestamp: expect.any(String),
        trend: expect.any(String),
        confidence: expect.any(Number),
        changeRate: expect.any(Number),
      })
    );

    expect(isISO(last.timestamp)).toBe(true);
    expect(in01(last.confidence)).toBe(true);
    expect(typeof last.changeRate).toBe('number');
  });
});
