import { describe, it, expect } from 'vitest';
import { detectMetaPatterns } from '../../lib/meta/reflection_core';
import { generateBlueprints } from '../../lib/meta/blueprint_generator';
import { validateRewrites } from '../../lib/meta/rewrite_validator';
import { applyBlueprints } from '../../lib/meta/apply_blueprints';

describe('Phase 6.5 — Meta-Reflection & Policy Self-Rewrite', () => {
  it('detects patterns, generates blueprints, validates and dry-applies a plan', () => {
    const patterns = [
      {
        policyId: 'POL-FEED-01',
        avgCorrelation: 0.82,
        volatility: 0.08,
        support: 5,
        direction: 'positive' as const,
      },
      {
        policyId: 'POL-STAB-02',
        avgCorrelation: -0.79,
        volatility: 0.09,
        support: 5,
        direction: 'negative' as const,
      },
    ];

    const blueprints = generateBlueprints(patterns);
    expect(blueprints.length).toBeGreaterThan(0);

    const plan = validateRewrites(blueprints);
    expect(plan.some((p) => p.valid)).toBe(true);

    const res = applyBlueprints(plan, { dryRun: true, step: 0.03 });
    expect(Array.isArray(res.updates)).toBe(true);
  });
});
