import { describe, it, expect } from 'vitest';
import { buildCausalMap } from '../../lib/conscious/causal_map';
import { generateInsights } from '../../lib/conscious/insight_engine';
import { refineRules } from '../../lib/conscious/rule_refiner';

describe('Phase 6.4 — Conscious Adaptation Layer', () => {
  it('builds causal map, generates insights, and refines rules', () => {
    const before = [{ policyId: 'POL-FEED-01', weight: 0.5 }];
    const after = [{ policyId: 'POL-FEED-01', weight: 0.55 }];
    const metricsBefore = { evolutionScore: 0.03 };
    const metricsAfter = { evolutionScore: 0.07 };

    const map = buildCausalMap(before, after, metricsBefore, metricsAfter);
    const insights = generateInsights(map);
    const rules = refineRules();

    expect(map.length).toBeGreaterThan(0);
    expect(insights.length).toBeGreaterThan(0);
    expect(Array.isArray(rules)).toBe(true);
  });
});
