#!/usr/bin/env bash
set -euo pipefail

# احترس من المسارات اللي فيها مسافات
PROJECT_DIR="$(pwd)"
REPORTS_DIR="$PROJECT_DIR/reports"
STAMP="$(date +%F_%H%M)"
OUT="$REPORTS_DIR/os-review-$STAMP.md"

mkdir -p "$REPORTS_DIR"

gemini -m gemini-2.5-pro -o text --include-directories Docs,app,components,data,hooks,lib \
"=== TASK: Portfolio OS — AI Architecture Review (v3)

ROLE
You are a senior OS architect & QA lead. Work non-interactively and produce one final Markdown report only.

SCOPE
Read and analyze these files if found:
- Docs/PORTFOLIO_FULL_ARCHITECTURE_REPORT.md
- Docs/AI_FEEDBACK_PORTFOLIO_OS.md
- Docs/IMPLEMENTATION_ROADMAP_PORTFOLIO_OS_v2.md
- Docs/PORTFOLIO_OS_SYSTEM_ARCHITECTURE_MASTER_PROMPT.md
- app/layout.tsx, app/page.tsx
- components/Desktop.tsx, components/Window.tsx, components/TopBar.tsx, components/Dock.tsx
- components/ActivitiesOverview.tsx, components/LoginScreen.tsx
- components/windows/*.tsx
- data/apps.tsx
- hooks/use-mobile.tsx, hooks/use-toast.ts
- lib/utils.ts
If a file is missing, note it in the report and proceed.

WHAT TO DO
1) Project Overview (stack, folder structure, runtime, assumptions).
2) Architecture & Interactions (data flow, state, z-index, window manager, deep-linking, persistence).
3) TypeScript Health (types, props, strictness, any-usage, tsconfig risks).
4) Security & Privacy (iframe sandbox, CSP hints, localStorage handling).
5) Accessibility (reduced-motion, keyboard nav, roles/labels).
6) Performance (lazy/suspense, re-renders, memos, bundle pressure).
7) Testing (current vitest status, coverage targets, 3–5 seed tests to add next).
8) DX & Config (Next.js version notes, config warnings, aliases, path with spaces).
9) Risks & Tradeoffs (top 5, likelihood/impact, mitigation).
10) Alignment Check: Compare current ‘Full Architecture Report’ vs ‘Implementation Roadmap v2’ and call out gaps or contradictions.
11) Action Plan: 3 sprints (Objectives/Tasks/AC/Owner).
12) Changelog Since Last Review.
13) Final Grades (A–F).

OUTPUT FORMAT (STRICT)
# Portfolio OS — AI Architecture Review (v3)
## Executive Summary
## Architecture & Component Interactions
## TypeScript Health
## Security & Privacy
## Accessibility
## Performance
## Testing Roadmap
## Developer Experience & Config
## Risks & Mitigations
## Alignment: Report ↔ Roadmap v2
## 3-Sprint Implementation Plan
## Changelog Since Last Review
## Quality Grades (A–F)
## Appendix (Missing Files / Notes)

Finish with a YAML block named NEXT_ACTIONS (title, path, rationale).

CONSTRAINTS
- Be specific to THIS repo; cite actual file paths.
- No edits; only focused snippets if needed.
- < 1,200 lines.

BEGIN." \
> "$OUT"

echo "============================================================"
echo "[AI Review] Saved: $OUT"
echo "============================================================"

