import { PolicyMeta } from './policy_types';
import { PolicyConfig } from '../../config/policy.config';

export function decideTrend(oldW: number, newW: number): '↑' | '↓' | '→' {
  if (oldW <= 0) return '→';
  const deltaNorm = (newW - oldW) / oldW;
  if (deltaNorm > PolicyConfig.trendDelta) return '↑';
  if (deltaNorm < -PolicyConfig.trendDelta) return '↓';
  return '→';
}

export function nextStatus(current: PolicyMeta, newWeight: number): PolicyMeta['status'] {
  if (newWeight < PolicyConfig.freezeThreshold) return 'frozen';
  if (current.status === 'frozen' && newWeight >= PolicyConfig.freezeThreshold) return 'review';
  return 'active';
}
