export function speak(text: string, opts: Partial<SpeechSynthesisUtterance> = {}) {
  if (typeof window === 'undefined' || !('speechSynthesis' in window)) return;
  const u = new SpeechSynthesisUtterance(text);
  u.lang = opts.lang || 'en-US';
  u.rate = opts.rate ?? 1.02;
  u.pitch = opts.pitch ?? 1;
  if (opts.voice) u.voice = opts.voice;
  window.speechSynthesis.cancel();
  window.speechSynthesis.speak(u);
}
export function stopSpeak() {
  if (typeof window === 'undefined') return;
  window.speechSynthesis?.cancel();
}
